/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util.auimlcvt.auiml;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AuimlJSPTools {
    private static final String FULL_PATTERN_DEF = "(<br>)|((?<!\\\\)\")|(%(?=\\w)|<html>|</html>|<body.*?>|</body>)";
    private static final String BR_PATTERN_DEF = "(<br>)";
    private static final String QUOTE_PATTERN_DEF = "((?<!\\\\)\")";
    private static final String SWING_PATTERN_DEF = "(%(?=\\w))";
    private static final String HTML_PATTERN_DEF = "(<html>|</html>|<body.*?>|</body>)";
    private static final Pattern FULL_PATTERN = Pattern.compile("(<br>)|((?<!\\\\)\")|(%(?=\\w)|<html>|</html>|<body.*?>|</body>)", 2);
    private static final Pattern BR_PATTERN = Pattern.compile("(<br>)", 2);
    private static final Pattern QUOTE_PATTERN = Pattern.compile("((?<!\\\\)\")", 2);
    private static final Pattern SWING_PATTERN = Pattern.compile("(%(?=\\w))", 2);
    private static final Pattern HTML_PATTERN = Pattern.compile("(<html>|</html>|<body.*?>|</body>)", 2);
    private static final String[] TEST_STRINGS = new String[]{"", "Foo <br>bar", "Foo bar<br>", "<br>Foo bar", "100%", "E%xit", "%Exit", "\"Howdy\"", "\\\"Howdy\\\"", "Hm\"mm", "<html>Test", "T<html>est", "Test<html>", "</html>End Test", "E</html>nd Test", "End Test</html>", "<body>Test 1", "T<body>est 1", "Test<body> 1", "<body bgcolor=\"black\">Test 1", "T<body  bgcolor=\"black\">est 1", "Test<body  bgcolor=\"black\"> 1", "</body>End Test", "E</body>nd Test", "End Test</body>"};

    private AuimlJSPTools() {
    }

    public static String cleanupResource(String inString) {
        if (inString == null) {
            return "";
        }
        return AuimlJSPTools.fullReplace(inString);
    }

    public static String cleanupResource(String inString, boolean fixQuotes, boolean fixBRTags, boolean stripHTML, boolean stripSwing) {
        if (fixQuotes && fixBRTags && stripHTML && stripSwing) {
            return AuimlJSPTools.cleanupResource(inString);
        }
        if (fixQuotes) {
            inString = AuimlJSPTools.replace(inString, QUOTE_PATTERN, "\\\\\"");
        }
        if (fixBRTags) {
            inString = AuimlJSPTools.replace(inString, BR_PATTERN, "<br/>");
        }
        if (stripSwing) {
            inString = AuimlJSPTools.replace(inString, SWING_PATTERN, "");
        }
        if (stripHTML) {
            inString = AuimlJSPTools.replace(inString, HTML_PATTERN, "");
        }
        return inString;
    }

    private static String paulCleanupResource(String inString, boolean fixQuotes, boolean fixBRTags, boolean stripHTML, boolean stripSwing) {
        if (inString == null) {
            return "";
        }
        int nextQuote = Integer.MAX_VALUE;
        int nextBR = Integer.MAX_VALUE;
        int nextPercent = Integer.MAX_VALUE;
        int nextStartHTML = Integer.MAX_VALUE;
        int nextEndHTML = Integer.MAX_VALUE;
        int nextStartBODY = Integer.MAX_VALUE;
        int nextEndBODY = Integer.MAX_VALUE;
        StringBuffer returnBuffer = new StringBuffer(inString.length());
        String tmpString = null;
        while (inString.length() > 0) {
            if (fixQuotes) {
                nextQuote = inString.indexOf("\"");
            }
            if (fixBRTags) {
                if (tmpString == null || tmpString.length() != inString.length()) {
                    tmpString = inString.toUpperCase();
                }
                if (nextBR >= 0) {
                    nextBR = tmpString.indexOf("<BR>");
                }
            }
            if (stripSwing) {
                nextPercent = inString.indexOf("%");
            }
            if (stripHTML) {
                if (tmpString == null || tmpString.length() != inString.length()) {
                    tmpString = inString.toUpperCase();
                }
                if (nextStartHTML >= 0) {
                    nextStartHTML = tmpString.indexOf("<HTML>");
                }
                if (nextEndHTML >= 0) {
                    nextEndHTML = tmpString.indexOf("</HTML>");
                }
                if (nextStartBODY >= 0) {
                    nextStartBODY = tmpString.indexOf("<BODY");
                }
                if (nextEndBODY >= 0) {
                    nextEndBODY = tmpString.indexOf("</BODY>");
                }
            }
            int nextCleanup = Integer.MAX_VALUE;
            if (nextQuote != -1 && nextQuote != Integer.MAX_VALUE && nextQuote < nextCleanup) {
                nextCleanup = nextQuote;
            }
            if (nextBR != -1 && nextBR != Integer.MAX_VALUE && nextBR < nextCleanup) {
                nextCleanup = nextBR;
            }
            if (nextPercent != -1 && nextPercent != Integer.MAX_VALUE && nextPercent < nextCleanup) {
                nextCleanup = nextPercent;
            }
            if (nextStartHTML != -1 && nextStartHTML != Integer.MAX_VALUE && nextStartHTML < nextCleanup) {
                nextCleanup = nextStartHTML;
            }
            if (nextEndHTML != -1 && nextEndHTML != Integer.MAX_VALUE && nextEndHTML < nextCleanup) {
                nextCleanup = nextEndHTML;
            }
            if (nextStartBODY != -1 && nextStartBODY != Integer.MAX_VALUE && nextStartBODY < nextCleanup) {
                nextCleanup = nextStartBODY;
            }
            if (nextEndBODY != -1 && nextEndBODY != Integer.MAX_VALUE && nextEndBODY < nextCleanup) {
                nextCleanup = nextEndBODY;
            }
            if (nextCleanup == Integer.MAX_VALUE) {
                returnBuffer.append(inString);
                inString = "";
                continue;
            }
            if (nextCleanup == nextQuote) {
                if (nextQuote > 0 && inString.charAt(nextQuote - 1) != '\\') {
                    returnBuffer.append(inString.substring(0, nextQuote) + "\\\"");
                } else if (nextQuote == 0) {
                    returnBuffer.append("\\\"");
                } else {
                    returnBuffer.append(inString.substring(0, nextQuote + 1));
                }
                inString = inString.substring(nextQuote + 1);
                continue;
            }
            if (nextCleanup == nextBR) {
                returnBuffer.append(inString.substring(0, nextBR) + "<br/>");
                inString = inString.substring(nextBR + 4);
                continue;
            }
            if (nextCleanup == nextPercent) {
                if (inString.length() == nextPercent + 1) {
                    returnBuffer.append(inString);
                    inString = "";
                    continue;
                }
                char c = inString.charAt(nextPercent + 1);
                if (Character.isLetter(c) || Character.isDigit(c)) {
                    returnBuffer.append(inString.substring(0, nextPercent));
                    inString = inString.substring(nextPercent + 1);
                    continue;
                }
                returnBuffer.append(inString.substring(0, nextPercent + 1));
                inString = inString.substring(nextPercent + 1);
                continue;
            }
            if (nextCleanup == nextStartHTML) {
                returnBuffer.append(inString.substring(0, nextStartHTML));
                if (inString.length() == nextStartHTML + 6) {
                    inString = "";
                    continue;
                }
                inString = inString.substring(nextStartHTML + 6);
                continue;
            }
            if (nextCleanup == nextEndHTML) {
                returnBuffer.append(inString.substring(0, nextEndHTML));
                if (inString.length() == nextEndHTML + 7) {
                    inString = "";
                    continue;
                }
                inString = inString.substring(nextEndHTML + 7);
                continue;
            }
            if (nextCleanup == nextStartBODY) {
                returnBuffer.append(inString.substring(0, nextStartBODY));
                int bodyEnd = inString.indexOf(">", nextStartBODY);
                if (bodyEnd < 0) {
                    bodyEnd = inString.length() + 1;
                }
                if (inString.length() == bodyEnd + 1) {
                    inString = "";
                    continue;
                }
                inString = inString.substring(bodyEnd + 1);
                continue;
            }
            if (nextCleanup != nextEndBODY) continue;
            returnBuffer.append(inString.substring(0, nextEndBODY));
            if (inString.length() == nextEndBODY + 7) {
                inString = "";
                continue;
            }
            inString = inString.substring(nextEndBODY + 7);
        }
        return returnBuffer.toString();
    }

    private static String fullReplace(String inString) {
        Matcher matcher = FULL_PATTERN.matcher(inString);
        StringBuffer newString = new StringBuffer(inString.length() + 10);
        while (matcher.find()) {
            if (matcher.group(1) != null) {
                matcher.appendReplacement(newString, "<br/>");
                continue;
            }
            if (matcher.group(2) != null) {
                matcher.appendReplacement(newString, "\\\\\"");
                continue;
            }
            matcher.appendReplacement(newString, "");
        }
        matcher.appendTail(newString);
        return newString.toString();
    }

    private static String replace(String inString, Pattern pattern, String replacement) {
        Matcher matcher = pattern.matcher(inString);
        StringBuffer newString = new StringBuffer(inString.length() + 10);
        while (matcher.find()) {
            matcher.appendReplacement(newString, replacement);
        }
        matcher.appendTail(newString);
        return newString.toString();
    }

    public static void main(String[] args) {
        StringBuffer myStringBuffer = new StringBuffer(150000);
        for (int i = 0; i < 5000; ++i) {
            myStringBuffer.append("1234567890 1234567890 1234567890 1234567890 1234567890 1234567890 <br>");
        }
        String myString = myStringBuffer.toString();
        long startTime = System.currentTimeMillis();
        long endTime = System.currentTimeMillis();
        long startTime1 = System.currentTimeMillis();
        AuimlJSPTools.fullReplace(myString);
        long endTime1 = System.currentTimeMillis();
        System.out.println("Paul Long test Elasped time: " + (endTime - startTime) / 1000L + "sec");
        System.out.println("Jim Long test Elasped time: " + (endTime1 - startTime1) + "msec");
        long startTime2 = System.currentTimeMillis();
        for (int i = 0; i < TEST_STRINGS.length; ++i) {
            AuimlJSPTools.paulCleanupResource(TEST_STRINGS[i], true, true, true, true);
        }
        long endTime2 = System.currentTimeMillis();
        long startTime3 = System.currentTimeMillis();
        for (int i = 0; i < TEST_STRINGS.length; ++i) {
            AuimlJSPTools.fullReplace(TEST_STRINGS[i]);
        }
        long endTime3 = System.currentTimeMillis();
        System.out.println("Paul Short tests Elasped time: " + (endTime2 - startTime2) + "msec");
        System.out.println("Jim Short tests Elasped time: " + (endTime3 - startTime3) + "msec");
    }
}

